#include "msglog.h"
#include <string.h>
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>

msglog::msglog()
{

}

msglog::~msglog()
{

}

void msglog::copySub (char* dest, char* source, unsigned long size) 
{
	unsigned long i;
	unsigned long j = 0;
	for (i = 0; i < size; i++) {
		dest[j++] = source[i];
	}
}

unsigned long msglog::ReadLong (char** pos) 
{
	unsigned long temp = 0;
	temp += ((unsigned char) (*pos)[0]);
	temp += ((unsigned char) (*pos)[1]) * 256;
	temp += ((unsigned char) (*pos)[2]) * 65536;
	temp += ((unsigned char) (*pos)[3]) * 16777216;
	(*pos) += 4;
	return temp;
}

unsigned short msglog::ReadShort (char** pos) 
{
	unsigned short temp = 0;
	temp += ((unsigned char) (*pos)[0]);
	temp += ((unsigned char) (*pos)[1]) * 256;
	(*pos) += 2;
	return temp;
}

unsigned char msglog::ReadByte (char** pos) 
{
	unsigned char temp;
	temp = (unsigned char) (*pos)[0];
	(*pos)++;
	return temp;
}

char msglog::ReadChar (char** pos) 
{
	char temp;
	temp = (char) (*pos)[0];
	(*pos)++;
	return temp;
}

float msglog::ReadFloat (char** pos) 
{
	float* temp;
	temp = (float*) (*pos);
	(*pos) += 4;
	return *temp;
}

char* msglog::ReadString (char** pos) 
{
	char* temp = (*pos);
	(*pos) += strlen ((*pos)) + 1;
	return temp;
}

void msglog::ReadPosition (char** pos, vec_t* vec) 
{
	int i;
    for (i = 0 ; i < 3 ; i++) vec[i] = (vec_t) ReadShort (pos) * 0.125;
}

void msglog::ReadDir (char** pos, vec_t* vec) 
{
	ReadByte (pos);
}

vec_t msglog::ReadAngle (char** pos) 
{
	return (vec_t) ReadChar (pos) * 360.0 / 256.0;
}

vec_t msglog::ReadAngle16 (char** pos) 
{
	return (vec_t) ReadShort (pos) * 360.0 / 65536.0;
}

vec_t msglog::ReadCoord (char** pos) 
{
	return (vec_t) ReadShort (pos) * 0.125;
}

long msglog::ReadEntity (char** pos) 
{
	return ReadShort (pos);
}

